<?php include_once('partials/header.php'); ?>

<!-- Hero Section -->
<section class="h-[80vh] flex items-center justify-center relative overflow-hidden hero-bg" style="background-image: url('assets/img/publicarea/1.jpg');">
    <div class="text-center text-white z-10">
        <div class="floating-animation">
            <h1 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-shadow-luxury tracking-wide"
                data-aos="zoom-in" data-aos-duration="1500">Accommodations</h1>
            <div class="accent-line mx-auto mb-4" data-aos="fade-up" data-aos-delay="300"></div>
            <p class="font-secondary text-xl lg:text-2xl font-light text-shadow-luxury tracking-wider italic"
                data-aos="fade-up" data-aos-delay="500">Sanctuaries of Serenity</p>
            <p class="font-body text-lg mt-4 text-shadow-luxury tracking-widest opacity-90" data-aos="fade-up"
                data-aos-delay="700">Where every room tells a story of Balinese elegance and timeless comfort</p>
        </div>
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black opacity-40"></div>
</section>

<!-- Introduction Section -->
<section class="py-20 bg-gradient-to-b from-white to-gray-50">
    <div class="max-w-5xl mx-auto px-6 text-center">
        <div data-aos="fade-up" class="space-y-8">
            <div class="luxury-divider"></div>
            <h2 class="text-4xl lg:text-5xl font-light text-gray-900 mb-6">
                Your Haven of
                <span class="gold-gradient">Tranquility</span>
            </h2>
            <p class="signature-text text-gray-700 text-xl leading-relaxed max-w-3xl mx-auto">
                Each accommodation at Asa Bali Luxury Villas and Spa is a carefully curated sanctuary, designed to embrace your soul with the perfect harmony of traditional Balinese architecture and contemporary luxury.
            </p>
        </div>
    </div>
</section>

<section class="py-32 relative">
    <div class="max-w-7xl mx-auto px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-24 items-center">
            <div data-aos="fade-right" data-aos-duration="1000">
                <div class="relative">
                    <div class="absolute -inset-4 bg-gradient-to-r from-yellow-400/20 to-amber-400/20 rounded-3xl blur opacity-30"></div>
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl">
                        <img src="<?= base_url() ?>assets/img/superior/1.jpg"
                            alt="ASA Bali Luxury Villas & Spa"
                            class="w-full h-96 object-cover">
                        <div class="absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
                        <div class="absolute bottom-4 left-4 text-white">
                            <span class="bg-yellow-500 px-3 py-1 rounded-full text-sm font-medium">Featured</span>
                        </div>
                    </div>
                </div>
            </div>

            <div data-aos="fade-left" data-aos-duration="1000" class="space-y-8">
                <div class="space-y-6">
                    <div class="luxury-divider"></div>
                    <h3 class="text-4xl lg:text-5xl font-light leading-tight text-gray-900">
                        Superior Private Pool Villa
                        <span class="gold-gradient block">Pool Villa</span>
                    </h3>
                    <!--    <div class="flex items-center space-x-4 text-gray-600">
                        <span class="flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                            300m² | 2 Guests
                        </span>
                    </div> -->
                </div>

                <div class="space-y-6">
                    <p class="signature-text text-gray-700 leading-relaxed">
                        ASA Bali Luxury Villas & Spa consists of 10 units Superior private pool villas, each open air in style, combining a fully equipped kitchenette, the dining corner and a spacious living room area with a private swimming pool surrounding within a lush tropical garden.
                    </p>

                    <div class="grid grid-cols-2 gap-4">
                        <!-- <div class="flex items-center text-gray-600">
                            <svg class="w-5 h-5 mr-3 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 15a4 4 0 004 4h9a5 5 0 10-.1-9.999 5.002 5.002 0 10-9.78 2.096A4.001 4.001 0 003 15z"></path>
                            </svg>
                            <span>Private Pool</span>
                        </div> -->
                        <div class="flex items-center text-gray-600">
                            <svg class="w-5 h-5 mr-3 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zM21 5a2 2 0 00-2-2h-4a2 2 0 00-2 2v12a4 4 0 004 4h4a2 2 0 002-2V5z"></path>
                            </svg>
                            <span>Tropical Garden</span>
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-5 h-5 mr-3 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span>King Bed</span>
                        </div>
                    </div>

                    <div class="bg-gradient-to-r from-yellow-50 to-amber-50 rounded-2xl p-6 border-l-4 border-yellow-500">
                        <p class="text-gray-800 font-medium mb-2">Starting from</p>
                        <p class="text-3xl font-light text-gray-900">
                            IDR 1.000K<span class="text-lg text-gray-600">/night</span>
                        </p>
                    </div>

                    <div class="flex space-x-4">
                        <a href="room/superior-private-pool-villa" class="luxury-button flex-1 text-center">
                            View Details
                        </a>
                        <a href="<?= variables()["booking"]["link"] ?>" class="luxury-button-outline flex-1 text-center">
                            Book Now
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="py-32 bg-gradient-to-b from-gray-50 to-white">
    <div class="max-w-7xl mx-auto px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-24 items-center">
            <div data-aos="fade-right" data-aos-duration="1000" class="order-2 lg:order-1 space-y-8">
                <div class="space-y-6">
                    <div class="luxury-divider"></div>
                    <h3 class="text-4xl lg:text-5xl font-light leading-tight text-gray-900">
                        One Bedroom Private
                        <span class="gold-gradient block">Pool Villa</span>
                    </h3>
                    <!--  <div class="flex items-center space-x-4 text-gray-600">
                        <span class="flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                            300m² | 2 Guests
                        </span>
                    </div> -->
                </div>

                <div class="space-y-6">
                    <p class="signature-text text-gray-700 leading-relaxed">
                        ASA Bali Luxury Villas & Spa comprises 8 units One Bedroom Pool Villas, each open air in style, combines a fully equipped kitchenette, the dining corner
                    </p>

                    <div class="grid grid-cols-2 gap-4">
                        <div class="flex items-center text-gray-600">
                            <svg class="w-5 h-5 mr-3 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 15a4 4 0 004 4h9a5 5 0 10-.1-9.999 5.002 5.002 0 10-9.78 2.096A4.001 4.001 0 003 15z"></path>
                            </svg>
                            <span>Private Pool</span>
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-5 h-5 mr-3 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zM21 5a2 2 0 00-2-2h-4a2 2 0 00-2 2v12a4 4 0 004 4h4a2 2 0 002-2V5z"></path>
                            </svg>
                            <span>Tropical Garden</span>
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-5 h-5 mr-3 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span>King Bed</span>
                        </div>
                    </div>

                    <div class="bg-gradient-to-r from-yellow-50 to-amber-50 rounded-2xl p-6 border-l-4 border-yellow-500">
                        <p class="text-gray-800 font-medium mb-2">Starting from</p>
                        <p class="text-3xl font-light text-gray-900">IDR 2.000K<span class="text-lg text-gray-600">/night</span></p>
                    </div>

                    <div class="flex space-x-4">
                        <a href="room/one-bedroom-pool-villa" class="luxury-button flex-1 text-center">View Details</a>
                        <a href="<?= variables()["booking"]["link"] ?>" class="luxury-button-outline flex-1 text-center">Book Now</a>
                    </div>
                </div>
            </div>
            <div data-aos="fade-left" data-aos-duration="1000" class="order-1 lg:order-2">
                <div class="relative">
                    <div class="absolute -inset-4 bg-gradient-to-r from-yellow-400/20 to-amber-400/20 rounded-3xl blur opacity-30"></div>
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl">
                        <img src="<?= base_url() ?>assets/img/onebedroompoolvilla/1.jpg" alt="ASA Bali Luxury Villas & Spa" class="w-full h-96 object-cover">
                        <div class="absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
                        <div class="absolute bottom-4 left-4 text-white">
                            <span class="bg-yellow-500 px-3 py-1 rounded-full text-sm font-medium">Featured</span>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </div>
</section>

<section class="py-32 bg-gradient-to-b from-gray-50 to-white">
    <div class="max-w-7xl mx-auto px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-24 items-center">
            <div data-aos="fade-right" data-aos-duration="1000" class="lg:order-1">
                <div class="relative">
                    <div class="absolute -inset-4 bg-gradient-to-r from-yellow-400/20 to-amber-400/20 rounded-3xl blur opacity-30"></div>
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl">
                        <img src="<?= base_url() ?>assets/img/twobedroompoolvilla/1.jpg" alt="ASA Bali Luxury Villas & Spa" class="w-full h-96 object-cover">
                        <div class="absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
                        <div class="absolute bottom-4 left-4 text-white">
                            <span class="bg-green-500 px-3 py-1 rounded-full text-sm font-medium">Popular</span>
                        </div>
                    </div>
                </div>
            </div>
            <div data-aos="fade-left" data-aos-duration="1000" class="space-y-8 lg:order-2">
                <div class="space-y-6">
                    <div class="luxury-divider"></div>
                    <h3 class="text-4xl lg:text-5xl font-light leading-tight text-gray-900">
                        Two Bedroom Private
                        <span class="gold-gradient block">Pool Villa</span>
                    </h3>
                    <!--  <div class="flex items-center space-x-4 text-gray-600">
                        <span class="flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                            550m² | 4 Guests
                        </span>
                    </div> -->
                </div>
                <div class="space-y-6">
                    <p class="signature-text text-gray-700 leading-relaxed">
                        ASA Bali Luxury Villas & Spa comprises 2 Two Bedrooms Pool Villas, each open air in style, combines a fully equipped kitchenette, the dining corner and a spacious living room area with a private swimming pool surrounding within a lush tropical Zen garden
                    </p>
                    <div class="grid grid-cols-2 gap-4">
                        <div class="flex items-center text-gray-600">
                            <svg class="w-5 h-5 mr-3 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 15a4 4 0 004 4h9a5 5 0 10-.1-9.999 5.002 5.002 0 10-9.78 2.096A4.001 4.001 0 003 15z"></path>
                            </svg>
                            <span>Private Pool</span>
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-5 h-5 mr-3 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                            </svg>
                            <span>Gazebo & Kitchen</span>
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-5 h-5 mr-3 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span>2 King Beds</span>
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-5 h-5 mr-3 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4"></path>
                            </svg>
                            <span>Dining Area</span>
                        </div>
                    </div>
                    <div class="bg-gradient-to-r from-yellow-50 to-amber-50 rounded-2xl p-6 border-l-4 border-yellow-500">
                        <p class="text-gray-800 font-medium mb-2">Starting from</p>
                        <p class="text-3xl font-light text-gray-900">IDR 3.000K<span class="text-lg text-gray-600">/night</span></p>
                    </div>
                    <div class="flex space-x-4">
                        <a href="room/two-bedroom-pool-villa" class="luxury-button flex-1 text-center">View Details</a>
                        <a href="<?= variables()["booking"]["link"] ?>" class="luxury-button-outline flex-1 text-center">Book Now</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="py-32 bg-gradient-to-b from-gray-50 to-white">
    <div class="max-w-7xl mx-auto px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-24 items-center">
            <div data-aos="fade-left" data-aos-duration="1000" class="lg:order-2">
                <div class="relative">
                    <div class="absolute -inset-4 bg-gradient-to-r from-yellow-400/20 to-amber-400/20 rounded-3xl blur opacity-30"></div>
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl">
                        <img src="<?= base_url() ?>assets/img/interconnecting/8.jpg"
                            alt="ASA Bali Luxury Villas & Spa"
                            class="w-full h-96 object-cover">
                        <div class="absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
                        <div class="absolute bottom-4 left-4 text-white">
                            <span class="bg-green-500 px-3 py-1 rounded-full text-sm font-medium">Family</span>
                        </div>
                    </div>
                </div>
            </div>

            <div data-aos="fade-right" data-aos-duration="1000" class="space-y-8 lg:order-1">
                <div class="space-y-6">
                    <div class="luxury-divider"></div>
                    <h3 class="text-4xl lg:text-5xl font-light leading-tight text-gray-900">
                        Interconnecting Two Bedroom
                        <span class="gold-gradient block">Private Pool Villa</span>
                    </h3>
                    <!--  <div class="flex items-center space-x-4 text-gray-600">
                        <span class="flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                            412m² | 4 Guests
                        </span>
                    </div> -->
                </div>

                <div class="space-y-6">
                    <p class="signature-text text-gray-700 leading-relaxed">
                        ASA Bali Luxury Villas & Spa comprises 4 units Interconnecting Two Bedroom Pool Villas each open air in style, combines a fully equipped kitchenette
                    </p>

                    <div class="grid grid-cols-2 gap-4">
                        <div class="flex items-center text-gray-600">
                            <svg class="w-5 h-5 mr-3 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 15a4 4 0 004 4h9a5 5 0 10-.1-9.999 5.002 5.002 0 10-9.78 2.096A4.001 4.001 0 003 15z"></path>
                            </svg>
                            <span>Private Pool</span>
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-5 h-5 mr-3 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                            </svg>
                            <span>Living Room</span>
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-5 h-5 mr-3 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span>2 King Beds</span>
                        </div>
                        <div class="flex items-center text-gray-600">
                            <svg class="w-5 h-5 mr-3 text-yellow-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4"></path>
                            </svg>
                            <span>Kitchen</span>
                        </div>
                    </div>

                    <div class="bg-gradient-to-r from-yellow-50 to-amber-50 rounded-2xl p-6 border-l-4 border-yellow-500">
                        <p class="text-gray-800 font-medium mb-2">Starting from</p>
                        <p class="text-3xl font-light text-gray-900">
                            IDR 3.000K<span class="text-lg text-gray-600">/night</span>
                        </p>
                    </div>

                    <div class="flex space-x-4">
                        <a href="room/interconnecting" class="luxury-button flex-1 text-center">
                            View Details
                        </a>
                        <a href="<?= variables()["booking"]["link"] ?>" class="luxury-button-outline flex-1 text-center">
                            Book Now
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>



<?php include_once('components/cta.php'); ?>
<?php include_once('partials/footer.php'); ?>