<?php include_once('partials/header.php'); ?>

<!-- Hero Section -->
<section class="h-[80vh] flex items-center justify-center relative overflow-hidden hero-bg" style="background-image: url('<?= base_url()?>assets/img/publicarea/1.jpg');">
    <div class="text-center text-white z-10">
        <div class="floating-animation">
            <h1 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-shadow-luxury tracking-wide"
                data-aos="zoom-in" data-aos-duration="1500">Other Service</h1>
            <div class="accent-line mx-auto mb-4" data-aos="fade-up" data-aos-delay="300"></div>
            <!-- <p class="font-secondary text-xl lg:text-2xl font-light text-shadow-luxury tracking-wider italic"
                data-aos="fade-up" data-aos-delay="500">Sanctuaries of Serenity</p> -->
            <p class="font-body text-lg mt-4 text-shadow-luxury tracking-widest opacity-90" data-aos="fade-up"
                data-aos-delay="700">A private and peaceful escape in Seminyak with pool villas and relaxing spa experiences.</p>
        </div>
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black opacity-40"></div>
</section>

<!-- Introduction Section -->
<section class="py-20 bg-gradient-to-b from-white to-gray-50">
    <div class="max-w-5xl mx-auto px-6 text-center">
        <div data-aos="fade-up" class="space-y-8">
            <div class="luxury-divider"></div>
            <h2 class="text-4xl lg:text-5xl font-light text-gray-900 mb-6">
                Asa Bali Luxury 
                <span class="gold-gradient">Villas & Spa</span>
            </h2>
            <p class="signature-text text-gray-700 text-xl leading-relaxed max-w-3xl mx-auto">
                is a peaceful hideaway in the heart of Seminyak. Featuring private pool villas, relaxing spa treatments, and warm Balinese hospitality, it’s the perfect place to unwind and enjoy a tropical escape.
            </p>
        </div>
    </div>
</section>

<section class="py-32 relative">
    <div class="max-w-7xl mx-auto px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-24 items-center">
            <div data-aos="fade-right" data-aos-duration="1000">
                <div class="relative">
                    <div class="absolute -inset-4 bg-gradient-to-r from-yellow-400/20 to-amber-400/20 rounded-3xl blur opacity-30"></div>
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl">
                        <img src="<?= base_url()?>assets/img/publicarea/6.jpg"
                            alt="One Bedroom Kembang Kertas"
                            class="w-full h-96 object-cover">
                        <div class="absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
                        <div class="absolute bottom-4 left-4 text-white">
                            <span class="bg-yellow-500 px-3 py-1 rounded-full text-sm font-medium">Featured</span>
                        </div>
                    </div>
                </div>
            </div>

            <div data-aos="fade-left" data-aos-duration="1000" class="space-y-8">
                <div class="space-y-6">
                    <div class="luxury-divider"></div>
                    <h3 class="text-4xl lg:text-5xl font-light leading-tight text-gray-900">
                        Other 
                        <span class="gold-gradient block">Service</span>
                    </h3>
                </div>

                <div class="space-y-6">
                    <p class="signature-text text-gray-700 leading-relaxed">
                    Airport Transfer<br>
                    Price : IDR 450,000.00 /car<br>
                    1x Airport Transfer ( Pick up or Drop to Airport ), please advise us your flight detail ( example by Air Asia73, Virgin 33, JetStar37 or Qantas 57 ? )
                    </p>

                    <!-- <div class="flex space-x-4">
                        <a href="#" class="luxury-button flex-1 text-center">
                            View Details
                        </a>
                        <a href="#" class="luxury-button-outline flex-1 text-center">
                            Book Now
                        </a>
                    </div> -->
                </div>
            </div>
        </div>
    </div>
</section>

<section class="py-32 bg-gradient-to-b from-gray-50 to-white">
    <div class="max-w-7xl mx-auto px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-24 items-center">
            <div data-aos="fade-right" data-aos-duration="1000" class="order-2 lg:order-1 space-y-8">
                <div class="space-y-6">
                    <div class="luxury-divider"></div>
                    <h3 class="text-4xl lg:text-5xl font-light leading-tight text-gray-900">
                        Honeymoon Decoration 
                        <span class="gold-gradient block">or Anniversary Decoration</span>
                    </h3>
                 
                </div>

                <div class="space-y-6">
                    <p class="signature-text text-gray-700 leading-relaxed">
                        
                        Price : IDR 900,000.00 /booking<br>
                        Price Including : 1x Flower on the pool, bed and bathtub
                    </p>

                    
                   

                    <!-- <div class="flex space-x-4">
                        <a href="room/one-bedroom-pool-villa" class="luxury-button flex-1 text-center">View Details</a>
                        <a href="#" class="luxury-button-outline flex-1 text-center">Book Now</a>
                    </div> -->
                </div>
            </div>
            <div data-aos="fade-left" data-aos-duration="1000" class="order-1 lg:order-2">
                <div class="relative">
                    <div class="absolute -inset-4 bg-gradient-to-r from-yellow-400/20 to-amber-400/20 rounded-3xl blur opacity-30"></div>
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl">
                        <img src="<?= base_url()?>assets/img/onebedroompoolvilla/1.jpg" alt="One Bedroom Pool Villa" class="w-full h-96 object-cover">
                        <div class="absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
                        <div class="absolute bottom-4 left-4 text-white">
                            <span class="bg-yellow-500 px-3 py-1 rounded-full text-sm font-medium">Featured</span>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </div>
</section>

<section class="py-32 bg-gradient-to-b from-gray-50 to-white">
    <div class="max-w-7xl mx-auto px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-24 items-center">
            <div data-aos="fade-right" data-aos-duration="1000" class="lg:order-1">
                <div class="relative">
                    <div class="absolute -inset-4 bg-gradient-to-r from-yellow-400/20 to-amber-400/20 rounded-3xl blur opacity-30"></div>
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl">
                        <img src="<?= base_url()?>assets/img/publicarea/2.jpg" alt="Two Bedroom Villa Anggrek" class="w-full h-96 object-cover">
                        <div class="absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
                        <div class="absolute bottom-4 left-4 text-white">
                            <span class="bg-green-500 px-3 py-1 rounded-full text-sm font-medium">Popular</span>
                        </div>
                    </div>
                </div>
            </div>
            <div data-aos="fade-left" data-aos-duration="1000" class="space-y-8 lg:order-2">
                <div class="space-y-6">
                    <div class="luxury-divider"></div>
                    <h3 class="text-4xl lg:text-5xl font-light leading-tight text-gray-900">
                        Floating 
                        <span class="gold-gradient block">Breakfast</span>
                    </h3>
                 
                </div>
                <div class="space-y-6">
                    <p class="signature-text text-gray-700 leading-relaxed">
                        
                        Price : IDR 250,000.00 /adult /booking<br>
                        Romantic private breakfast with floating at the pool villa
                    </p>
                 
                    <!--  <div class="flex space-x-4">
                        <a href="room/two-bedroom-pool-villa" class="luxury-button flex-1 text-center">View Details</a>
                        <a href="#" class="luxury-button-outline flex-1 text-center">Book Now</a>
                    </div> -->
                </div>
            </div>
        </div>
    </div>
</section>





<?php include_once('components/cta.php'); ?>
<?php include_once('partials/footer.php'); ?>