<?php include_once(__DIR__ . '/../functions/helper.php'); ?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= variables()["title"] ?? "BOOKNPAY" ?> - Official Site</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@300;400;500;600;700&family=Crimson+Text:ital,wght@0,400;0,600;1,400&family=Cormorant+Garamond:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">
    <!-- AOS CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css" rel="stylesheet">
    <style>
        .font-primary {
            font-family: 'Playfair Display', serif;
        }

        .font-secondary {
            font-family: 'Cormorant Garamond', serif;
        }

        .font-body {
            font-family: 'Crimson Text', serif;
        }

        html {
            overflow-x: hidden;
        }

        body {
            overflow: hidden;
            font-family: 'Crimson Text', serif;
            line-height: 1.7;
            letter-spacing: 0.3px;
        }

        .hero-bg {
            background: linear-gradient(rgba(0, 0, 0, 0.15), rgba(0, 0, 0, 0.35)),
                url('/assets/img/publicarea/1.jpg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
        }

        .luxury-shadow {
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.12), 0 8px 25px rgba(0, 0, 0, 0.08);
        }

        .text-shadow-luxury {
            text-shadow: 0 2px 20px rgba(0, 0, 0, 0.3), 0 1px 3px rgba(0, 0, 0, 0.4);
        }

        .gradient-text {
            background: linear-gradient(135deg, #c9a96e 0%, #f4e4bc 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .accent-line {
            width: 60px;
            height: 1px;
            background: linear-gradient(90deg, #c9a96e 0%, #f4e4bc 50%, #c9a96e 100%);
        }

        .gold-accent {
            color: #c9a96e;
        }

        .btn-luxury {
            background: linear-gradient(135deg, #c9a96e 0%, #ddbf94 100%);
            transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }

        .btn-luxury:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 40px rgba(201, 169, 110, 0.3);
        }

        .floating-animation {
            animation: float 6s ease-in-out infinite;
        }

        .luxury-button {
            background-color: #fbbf24;
            color: #fff;
            border: 1px solid #fbbf24;
            padding: 1rem;
        }

        .luxury-button-outline {
            background-color: transparent;
            color: #000 !important;
            border: 1px solid #fbbf24;
            padding: 1rem;
        }

        @keyframes float {

            0%,
            100% {
                transform: translateY(0px);
            }

            50% {
                transform: translateY(-10px);
            }
        }

        .luxury-border {
            position: relative;
        }

        .luxury-border::before {
            content: '';
            position: absolute;
            top: -2px;
            left: -2px;
            right: -2px;
            bottom: -2px;
            background: linear-gradient(45deg, #c9a96e, #f4e4bc, #c9a96e);
            border-radius: inherit;
            z-index: -1;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .luxury-border:hover::before {
            opacity: 1;
        }

        /* Navbar */
        .backdrop-luxury {
            backdrop-filter: blur(12px) saturate(150%);
            background: rgba(0, 0, 0, 0.1);
            -webkit-backdrop-filter: blur(15px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .gold-border {
            border-color: #fbbf24;
            background: linear-gradient(45deg, transparent 30%, rgba(251, 191, 36, 0.1) 50%, transparent 70%);
        }

        .gold-border:hover {
            background: linear-gradient(45deg, #fbbf24, #f59e0b);
            box-shadow: 0 0 20px rgba(251, 191, 36, 0.3);
            transform: translateY(-1px);
        }

        .mobile-menu {
            background: linear-gradient(135deg, rgba(0, 0, 0, 0.95) 0%, rgba(30, 30, 30, 0.98) 100%);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            transform: translateX(100%);
            transition: transform 0.4s cubic-bezier(0.23, 1, 0.320, 1);
        }

        .mobile-menu.active {
            transform: translateX(0);
        }

        .hamburger {
            width: 24px;
            height: 20px;
            position: relative;
            cursor: pointer;
        }

        .hamburger span {
            display: block;
            position: absolute;
            height: 2px;
            width: 100%;
            background: white;
            border-radius: 1px;
            transition: all 0.3s ease;
        }

        .hamburger span:nth-child(1) {
            top: 0;
        }

        .hamburger span:nth-child(2) {
            top: 50%;
            transform: translateY(-50%);
        }

        .hamburger span:nth-child(3) {
            bottom: 0;
        }

        .hamburger.active span:nth-child(1) {
            transform: rotate(45deg);
            top: 50%;
            margin-top: -1px;
        }

        .hamburger.active span:nth-child(2) {
            opacity: 0;
        }

        .hamburger.active span:nth-child(3) {
            transform: rotate(-45deg);
            bottom: 50%;
            margin-bottom: -1px;
        }

        .menu-item {
            opacity: 0;
            transform: translateX(50px);
            transition: all 0.3s ease;
        }

        .mobile-menu.active .menu-item {
            opacity: 1;
            transform: translateX(0);
        }

        .menu-item:nth-child(1) {
            transition-delay: 0.1s;
        }

        .menu-item:nth-child(2) {
            transition-delay: 0.15s;
        }

        .menu-item:nth-child(3) {
            transition-delay: 0.2s;
        }

        .menu-item:nth-child(4) {
            transition-delay: 0.25s;
        }

        .menu-item:nth-child(5) {
            transition-delay: 0.3s;
        }

        .menu-item:nth-child(6) {
            transition-delay: 0.35s;
        }

        .menu-item:nth-child(7) {
            transition-delay: 0.4s;
        }

        .menu-item:nth-child(8) {
            transition-delay: 0.45s;
        }

        .menu-item:nth-child(9) {
            transition-delay: 0.5s;
        }

        .philosophy-bg {
            background: linear-gradient(135deg, #1a1a1a 0%, #2a2a2a 50%, #0a0a0a 100%);
            position: relative;
        }

        .luxury-divider {
            width: 100px;
            height: 2px;
            background: linear-gradient(90deg, transparent, #d4af37, transparent);
            margin: 2rem auto;
        }

        .luxury-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(212, 175, 55, 0.2);
            transition: all 0.6s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .offer-badge {
            background: linear-gradient(135deg, #d4af37 0%, #ffd700 50%, #b8860b 100%);
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 2rem;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            position: absolute;
            top: 1rem;
            right: 1rem;
            z-index: 10;
        }

        .luxury-divider {
            width: 100px;
            height: 2px;
            background: linear-gradient(90deg, transparent, #d4af37, transparent);
            margin: 2rem auto;
        }

        .signature-text {
            font-size: 1.1rem;
            line-height: 1.8;
            letter-spacing: 0.025em;
        }

        .floating-element {
            animation: float 6s ease-in-out infinite;
        }

        @keyframes float {

            0%,
            100% {
                transform: translateY(0px);
            }

            50% {
                transform: translateY(-20px);
            }
        }

        .price-highlight {
            background: linear-gradient(135deg, #d4af37 0%, #ffd700 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .offer-image {
            transition: transform 0.8s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .luxury-card:hover .offer-image {
            transform: scale(1.05);
        }

        .seasonal-bg {
            background: linear-gradient(135deg, #fafafa 0%, #ffffff 100%);
            position: relative;
        }

        .seasonal-bg::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at 20% 80%, rgba(212, 175, 55, 0.1) 0%, transparent 50%);
        }

        .cta-button {
            background: linear-gradient(135deg, #d4af37 0%, #ffd700 100%);
            color: white;
            border: none;
            padding: 1rem 2rem;
            border-radius: 2rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .cta-button::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: left 0.6s ease;
        }

        .cta-button:hover::before {
            left: 100%;
        }

        .cta-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(212, 175, 55, 0.3);
        }
    </style>
</head>

<body class="bg-white">
    <!-- Navigation -->
    <nav class="fixed top-0 w-full z-50 backdrop-luxury">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 lg:py-6">
            <div class="flex items-center justify-between">
                <!-- Logo -->
                <div class="text-white font-primary font-bold text-xl sm:text-2xl tracking-wider">
                    <a href="<?= base_url() ?>">
                        <img src="<?= base_url() ?>assets/img/logo/logo.png" alt="" class="w-[200px]">
                    </a>
                </div>

                <!-- Desktop Menu -->
                <div
                    class="hidden lg:flex items-center space-x-8 text-white text-sm font-secondary uppercase tracking-widest">

                    <a href="<?= base_url() ?>index" class="hover:text-yellow-200 transition-colors duration-300 py-2">Home</a>
                    <a href="<?= base_url() ?>accommodation"
                        class="hover:text-yellow-200 transition-colors duration-300 py-2">Accommodation</a>
                    <a href="<?= base_url() ?>spa" class="hover:text-yellow-200 transition-colors duration-300 py-2">Spa</a>
                    <a href="<?= base_url() ?>restaurant" class="hover:text-yellow-200 transition-colors duration-300 py-2">Restaurant & Bar</a>
                    <a href="<?= base_url() ?>other" class="hover:text-yellow-200 transition-colors duration-300 py-2">Other Service</a>
                    <a href="<?= base_url() ?>package"
                        class="hover:text-yellow-200 transition-colors duration-300 py-2">Package</a>
                    <a href="<?= base_url() ?>galleries" class="hover:text-yellow-200 transition-colors duration-300 py-2">Gallery</a>

                    <!-- <a href="/discover" class="hover:text-yellow-200 transition-colors duration-300 py-2">Discover</a> -->
                </div>

                <!-- Desktop CTA & Language -->
                <div class="hidden lg:flex items-center space-x-6">
                    <a href="<?= variables()["booking"]["link"] ?>" class="text-white border-2 gold-border px-6 py-2 text-sm font-secondary uppercase tracking-wider hover:bg-yellow-200 hover:text-gray-900 transition-all duration-300">
                        Book Now
                    </a>
                </div>

                <!-- Mobile Menu Button -->
                <div class="lg:hidden">
                    <button id="mobile-menu-button" class="hamburger">
                        <span></span>
                        <span></span>
                        <span></span>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile Menu Overlay -->
        <div id="mobile-menu" class="mobile-menu fixed top-0 right-0 w-full sm:w-80 h-full z-40 lg:hidden">
            <div class="bg-gray-900 p-8 pt-20 h-screen">
                <!-- Close Button -->
                <div class="flex justify-end mb-8">
                    <button id="close-menu-button"
                        class="text-white hover:text-yellow-200 transition-colors duration-300">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
                <!-- Mobile Menu Items -->
                <div class="space-y-6">

                    <!-- <a href="/discover" class="hover:text-yellow-200 transition-colors duration-300 py-2">Discover</a> -->
                    <a href="<?= base_url() ?>accommodation"
                        class="menu-item block text-white font-secondary text-lg uppercase tracking-widest hover:text-yellow-200 transition-colors duration-300 border-b border-gray-700 pb-4">Accommodation</a>
                    <a href="<?= base_url() ?>spa"
                        class="menu-item block text-white font-secondary text-lg uppercase tracking-widest hover:text-yellow-200 transition-colors duration-300 border-b border-gray-700 pb-4">Spa</a>
                    <a href="<?= base_url() ?>restaurant"
                        class="menu-item block text-white font-secondary text-lg uppercase tracking-widest hover:text-yellow-200 transition-colors duration-300 border-b border-gray-700 pb-4">Restaurant & Bar</a>
                    <a href="<?= base_url() ?>other"
                        class="menu-item block text-white font-secondary text-lg uppercase tracking-widest hover:text-yellow-200 transition-colors duration-300 border-b border-gray-700 pb-4">Other Service</a>
                    <a href="<?= base_url() ?>package"
                        class="menu-item block text-white font-secondary text-lg uppercase tracking-widest hover:text-yellow-200 transition-colors duration-300 border-b border-gray-700 pb-4">Package</a>
                    <a href="<?= base_url() ?>galleries"
                        class="menu-item block text-white font-secondary text-lg uppercase tracking-widest hover:text-yellow-200 transition-colors duration-300 border-b border-gray-700 pb-4">Gallery</a>
                    <a href="<?= base_url() ?>discover"
                        class="menu-item block text-white font-secondary text-lg uppercase tracking-widest hover:text-yellow-200 transition-colors duration-300 border-b border-gray-700 pb-4">Discover</a>

                    <!-- Mobile CTA & Language -->
                    <div class="menu-item pt-6 space-y-4">
                        <a href="<?= variables()["booking"]["link"] ?>"
                            class="w-full text-white border-2 gold-border px-6 py-3 text-sm font-secondary uppercase tracking-wider hover:bg-yellow-200 hover:text-gray-900 transition-all duration-300">
                            Book Now
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </nav>