<?php include_once('partials/header.php'); ?>

<!-- Hero Section -->
<section id="spa_hero_section" class="hero-bg h-[80vh] flex items-center justify-center relative overflow-hidden" style="background-image: url('<?= base_url()?>assets/img/restaurant/1.jpg');">
    <div class="text-center text-white z-10">
        <div class="floating-animation">
            <h1 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-shadow-luxury tracking-wide"
                data-aos="zoom-in" data-aos-duration="1500">Dining</h1>
            <div class="accent-line mx-auto mb-4" data-aos="fade-up" data-aos-delay="300"></div>
            <p class="font-secondary text-xl lg:text-2xl font-light text-shadow-luxury tracking-wider italic"
                data-aos="fade-up" data-aos-delay="500">Flavours of culinary art and wine served in the Kubu Bar & Restaurant.</p>
            <p class="font-body text-lg mt-4 text-shadow-luxury tracking-widest opacity-90" data-aos="fade-up"
                data-aos-delay="700">Asa Bali Luxury Villas & Spa, Bali</p>
        </div>
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black opacity-20"></div>
</section>

<!-- Spa Introduction -->
<section id="spa_introduction" class="py-24 bg-gradient-to-b from-white to-gray-50">
    <div class="max-w-7xl mx-auto px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
            <!-- Text Content -->
            <div class="space-y-8" data-aos="fade-right" data-aos-duration="1000">
                <h2 class="font-primary text-5xl lg:text-6xl font-light gradient-text leading-tight mb-6">Dining</h2>
                <div class="accent-line mb-8"></div>
                <div class="space-y-6 font-body text-gray-700 text-lg leading-relaxed">
                    <p>A wealth of venues dot the island. Wholesome breakfasts, playful Indonesian lunches. Unhurried all-day dining. Comfort foods and bold, authentic flavours. Choose from aroma of the South Asia spices to hearty Western cuisine</p>
                    <p class="italic text-xl font-light gold-accent">Timeless moments of relaxation. Options to suit each and every taste.</p>
                </div>
            </div>
            <!-- Spa Image -->
            <div data-aos="fade-left" data-aos-duration="1000">
                <div class="aspect-[4/3] luxury-border rounded-2xl overflow-hidden luxury-shadow">
                    <div class="w-full h-full bg-cover bg-center" style="background-image: url('<?= base_url()?>assets/img/restaurant/1.jpg');"></div>
                </div>
            </div>
        </div>
    </div>
</section>



<?php render(__DIR__ . '/components/galleries.php', [
    "section_data" => [
        "id" => "spa_gallery",
        "title" => "Restaurant",
        "galleries" => [
            [
                "link" => "assets/img/restaurant/1.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/restaurant/2.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/restaurant/3.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/restaurant/4.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/restaurant/5.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/restaurant/6.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/restaurant/7.jpg",
                "text" => ""
            ],
            
            [
                "link" => "assets/img/restaurant/9.jpg",
                "text" => ""
            ],
        ]
    ]
]) ?>

<?php include_once('components/cta.php'); ?>

<?php include_once('partials/footer.php'); ?>