<?php include_once(__DIR__ . '/../partials/header.php'); ?>

<section id="room_detail_hero" class="hero-bg h-[70vh] flex items-center justify-center relative overflow-hidden" style="background-image: url('<?= base_url()?>assets/img/interconnecting/1.jpg');">
    <div class="text-center text-white z-10">
        <div class="floating-animation mt-12">
            <h1 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-shadow-luxury tracking-wide"
                data-aos="zoom-in" data-aos-duration="1500">Interconnecting Two Bedroom Private Pool Villa</h1>
            <div class="accent-line mx-auto mb-4" data-aos="fade-up" data-aos-delay="300"></div>
            <p class="font-secondary text-xl lg:text-2xl font-light text-shadow-luxury tracking-wider italic"
                data-aos="fade-up" data-aos-delay="500">Exceptional Comfort In The Tropics</p>
            <p class="font-body text-lg mt-4 text-shadow-luxury tracking-widest opacity-90" data-aos="fade-up"
                data-aos-delay="700">Bali, Indonesia</p>
        </div>
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black opacity-20"></div>
</section>

<section id="room_detail_content" class="py-24 bg-gradient-to-b from-white to-gray-50">
    <div class="max-w-7xl mx-auto px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-20 items-center">
            <!-- Left Content -->
            <div class="space-y-8" data-aos="fade-right" data-aos-duration="1000">
                <div>
                    <h2 class="font-primary text-5xl lg:text-6xl font-light gradient-text leading-tight mb-6">INTERCONNECTING TWO BEDROOM PRIVATE POOL VILLA</h2>
                    <div class="accent-line mb-8"></div>
                </div>
                <div class="space-y-6 font-body text-gray-700 text-lg leading-relaxed">
                    <p class="font-light" data-aos="fade-up" data-aos-delay="200">
                    ASA Bali Luxury Villas & Spa comprises 4 units Interconnecting Two Bedroom Pool Villas each open air in style, combines a fully equipped kitchenette, the dining corner and a spacious living room area with a private swimming pool surrounding within a lush tropical garden.
                    </p>
                    <p data-aos="fade-up" data-aos-delay="400">Interconnecting Two Bed Room Private Pool Villa merging from 2 Deluxe one bed room private pool villas into one villa with Interconnecting Two bed room private pool villa.
                    Location in Asa 2 is located 100 meters from main building Asa 1 and we prepared a buggy for the shuttle from the main building</p>
                </div>
            </div>

            <!-- Right Image -->
            <div class="relative" data-aos="fade-left" data-aos-duration="1000">
                <div class="aspect-[4/3] luxury-border rounded-2xl overflow-hidden luxury-shadow">
                    <div class="w-full h-full bg-cover bg-center" style="background-image: url('<?= base_url()?>assets/img/interconnecting/2.jpg');">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php render(__DIR__ . '/../components/galleries.php', [
    "section_data" => [
        "id" => "room_detail_gallery",
        "title" => "Room Gallery",
        "galleries" => [
            [
                "link" => "assets/img/interconnecting/1.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/interconnecting/2.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/interconnecting/3.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/interconnecting/4.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/interconnecting/5.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/interconnecting/6.jpg",
                "text" => ""
            ],
           
        ]
    ]
]) ?>

<!-- <section id="room_detail_facilities" class="py-20 bg-gray-50">
    <div class="max-w-7xl mx-auto px-8">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-12">
            <div data-aos="fade-up" data-aos-delay="50">
                <h4
                    class="font-secondary font-semibold text-gray-900 mb-6 text-sm uppercase tracking-widest gold-accent">
                    Room Information</h4>
                <div class="space-y-2 font-body text-gray-600">
                    <p>• King (200x200) / 2 Single ( 100x200)</p>
                    <p>• Up to 3 Adults</p>
                    <p>• 3m x 10m Private Pool , 1.5 m deep</p>
                    <p>• Tropical Lush Garden</p>
                </div>
            </div>
            <div data-aos="fade-up" data-aos-delay="100">
                <h4
                    class="font-secondary font-semibold text-gray-900 mb-6 text-sm uppercase tracking-widest gold-accent">
                    Room Facilities</h4>
                <div class="space-y-2 font-body text-gray-600">
                    <p>• Air Conditioner</p>
                    <p>• International direct phone call</p>
                    <p>• Dining Table & Chair</p>
                    <p>• Fully Equipment Kitchenette</p>
                    <p>• Hair Dryer</p>
                    <p>• King / Hollywood Bed with mosquito nets</p>
                    <p>• Laundry Box</p>
                    <p>• Massage Bed</p>
                    <p>• Refrigerator</p>
                    <p>• Safety Box</p>
                </div>
            </div>
            <div data-aos="fade-up" data-aos-delay="200">
                <h4
                    class="font-secondary font-semibold text-gray-900 mb-6 text-sm uppercase tracking-widest gold-accent">
                    Other Room Facilities</h4>
                <div class="space-y-2 font-body text-gray-600">
                    <p>• Sofa</p>
                    <p>• Table Lamp</p>
                    <p>• Tea Coffee making facilities</p>
                    <p>• Telephone</p>
                    <p>• TV Cable</p>
                    <p>• Water Dispenser</p>
                    <p>• Weigh Scale</p>
                    <p>• WIFI</p>
                    <p>• Writing Table & Chair</p>
                    <p>• Wardrobe</p>
                </div>
            </div>
            <div data-aos="fade-up" data-aos-delay="300">
                <h4
                    class="font-secondary font-semibold text-gray-900 mb-6 text-sm uppercase tracking-widest gold-accent">
                    Room Amenities</h4>
                <div class="space-y-2 font-body text-gray-600">
                    <p>• Bathroom amenities (bath gel, shampoo, conditioner ,razor, dental kit, cotton buds, sanitary, shower cup)</p>
                    <p>• Bathrobe</p>
                    <p>• Slippers</p>
                    <p>• Rain shower</p>
                    <p>• Iron ( on Request )</p>
                </div>
            </div>
        </div>
    </div>
</section> -->

<?php include_once(__DIR__ . '/../components/cta.php'); ?>
<?php include_once(__DIR__ . '/../partials/footer.php'); ?>