<?php include_once('partials/header.php'); ?>

<!-- Hero Section -->
<section id="spa_hero_section" class="hero-bg h-[80vh] flex items-center justify-center relative overflow-hidden" style="background-image: url('<?= base_url()?>assets/img/spa/1.jpg');">
    <div class="text-center text-white z-10">
        <div class="floating-animation">
            <h1 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-shadow-luxury tracking-wide"
                data-aos="zoom-in" data-aos-duration="1500">Toya ASA Spa</h1>
            <div class="accent-line mx-auto mb-4" data-aos="fade-up" data-aos-delay="300"></div>
            <p class="font-secondary text-xl lg:text-2xl font-light text-shadow-luxury tracking-wider italic"
                data-aos="fade-up" data-aos-delay="500">Revive your senses in the sanctuary of serenity</p>
            <p class="font-body text-lg mt-4 text-shadow-luxury tracking-widest opacity-90" data-aos="fade-up"
                data-aos-delay="700">Asa Bali Luxury Villas & Spa, Bali</p>
        </div>
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black opacity-20"></div>
</section>

<!-- Spa Introduction -->
<section id="spa_introduction" class="py-24 bg-gradient-to-b from-white to-gray-50">
    <div class="max-w-7xl mx-auto px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
            <!-- Text Content -->
            <div class="space-y-8" data-aos="fade-right" data-aos-duration="1000">
                <h2 class="font-primary text-5xl lg:text-6xl font-light gradient-text leading-tight mb-6">A Sanctuary of Bliss</h2>
                <div class="accent-line mb-8"></div>
                <div class="space-y-6 font-body text-gray-700 text-lg leading-relaxed">
                    <p>Waves of energy from the Balinese vibrant culture, rushing ocean currents, abundant marine life. Toya ASA Spa channels the living, breathing vibe of this place into deep healing rituals. .</p>
                    <p class="italic text-xl font-light gold-accent">Timeless moments of relaxation. Toya ASA Spa’s are designed to restore balance and harmony between body and mind in an oasis of beauty, grace and tranquility</p>
                </div>
            </div>
            <!-- Spa Image -->
            <div data-aos="fade-left" data-aos-duration="1000">
                <div class="aspect-[4/3] luxury-border rounded-2xl overflow-hidden luxury-shadow">
                    <div class="w-full h-full bg-cover bg-center" style="background-image: url('<?= base_url()?>assets/img/spa/2.jpg');"></div>
                </div>
            </div>
        </div>
    </div>
</section>



<?php render(__DIR__ . '/components/galleries.php', [
    "section_data" => [
        "id" => "spa_gallery",
        "title" => "Spa Gallery",
        "galleries" => [
            [
                "link" => "assets/img/spa/1.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/spa/2.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/spa/3.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/spa/4.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/spa/5.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/spa/6.jpg",
                "text" => ""
            ],
            
        ]
    ]
]) ?>

<!-- Call to Action -->
<section class="py-24 bg-gradient-to-br from-yellow-50 to-white">
    <div class="max-w-4xl mx-auto px-8 text-center">
        <h2 class="text-3xl md:text-4xl font-semibold mb-4" data-aos="fade-up">Book Your Spa Journey</h2>
        <p class="text-gray-600 mb-8 text-sm md:text-base" data-aos="fade-up" data-aos-delay="200">
            Let us take care of your well-being. Contact us to reserve your spa session or learn more about our wellness offerings.
        </p>
        <a href="mailto:info@asabaliluxuryvillas.com" target="_blank"
            class="btn-luxury text-gray-900 px-12 py-4 font-secondary text-sm uppercase tracking-widest font-semibold rounded-full"
            data-aos="fade-up" data-aos-delay="400">Reserve Now</a>
    </div>
</section>

<?php include_once('partials/footer.php'); ?>