<?php include_once('partials/header.php'); ?>

<!-- Hero Section -->
<section class="hero-bg h-screen flex items-center justify-center relative overflow-hidden" style="background-image: url('<?= base_url() ?>assets/img/publicarea/6.jpg');">
    <div class="text-center text-white z-10">
        <div class="floating-animation">
            <h1 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-shadow-luxury tracking-wide"
                data-aos="zoom-in" data-aos-duration="1500"><?= variables()["title"] ?></h1>
            <div class="accent-line mx-auto mb-4" data-aos="fade-up" data-aos-delay="300"></div>
            <p class="font-secondary text-xl lg:text-2xl font-light text-shadow-luxury tracking-wider italic"
                data-aos="fade-up" data-aos-delay="500">Designed with elegance and comfort, offering the perfect hideaway on the hillside</p>
            <p class="font-body text-lg mt-4 text-shadow-luxury tracking-widest opacity-90" data-aos="fade-up"
                data-aos-delay="700">Bali, Indonesia</p>
        </div>
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black opacity-20"></div>
</section>

<!-- Main Content Section -->
<section class="py-24 bg-gradient-to-b from-white to-gray-50">
    <div class="max-w-7xl mx-auto px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-20 items-center">
            <!-- Left Content -->
            <div class="space-y-8" data-aos="fade-right" data-aos-duration="1000">
                <div>
                    <h2 class="font-primary text-5xl lg:text-6xl font-light gradient-text leading-tight mb-6">Relax in modern comfort</h2>
                    <div class="accent-line mb-8"></div>
                </div>
                <div class="space-y-6 font-body text-gray-700 text-lg leading-relaxed">
                    <p class="font-light" data-aos="fade-up" data-aos-delay="200">A cozy 2-bedroom villa in Nusa Dua, Bali. It’s perfect for couples or small families, with a private pool, garden, full kitchen, and comfy living space. Quiet, safe, and just minutes from the beach — great for monthly or long stays.offers a private pool, free Wifi, and free private parking. 
                    </p>
                    <p class="italic text-xl font-light gold-accent" data-aos="fade-up" data-aos-delay="800">The accommodation offers a shared kitchen and private check-in and check-out for guests.</p>
                </div>
            </div>

            <!-- Right Image -->
            <div class="relative" data-aos="fade-left" data-aos-duration="1000">
                <div class="aspect-[4/3] luxury-border rounded-2xl overflow-hidden luxury-shadow">
                    <div class="w-full h-full bg-cover bg-center" style="background-image: url('<?= base_url() ?>assets/img/other/1.jpg');">
                    </div>
                    <div class="absolute bottom-8 left-8">
                        <h3 class="text-white font-primary text-3xl font-light text-shadow-luxury"
                            data-aos="fade-up" data-aos-delay="300">Infinite
                            layers of comfort</h3>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Contact Info Section -->
<!--<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-8">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-12">
            <div data-aos="fade-up" data-aos-delay="100">
                <h4 class="font-secondary font-semibold text-gray-900 mb-6 text-sm uppercase tracking-widest gold-accent">
                    Getting Here</h4>
                <div class="space-y-3 font-body text-gray-600">
                    <p><?= variables()["address"]["text"] ?></p>
                    <p class="text-sm gold-accent cursor-pointer hover:underline"><a href="<?= variables()["email"]["link"] ?>" target="_blank">View on google map</a></p>
                </div>
            </div>
            <div data-aos="fade-up" data-aos-delay="200">
                <h4
                    class="font-secondary font-semibold text-gray-900 mb-6 text-sm uppercase tracking-widest gold-accent">
                    Reservation</h4>
                <div class="space-y-3 font-body text-gray-600">
                    <p>For reservation & accommodation</p>
                    <p class="font-semibold"><a href="<?= variables()["whatsapp"]["link"] ?>" target="_blank"><?= variables()["whatsapp"]["text"] ?></a></p>
                    <p class="text-sm gold-accent cursor-pointer hover:underline"><a href="<?= variables()["email"]["link"] ?>" target="_blank">Email us about</a></p>
                </div>
            </div>
            <div data-aos="fade-up" data-aos-delay="300">
                <h4
                    class="font-secondary font-semibold text-gray-900 mb-6 text-sm uppercase tracking-widest gold-accent">
                    Facilities and Services</h4>
                <div class="space-y-2 font-body text-gray-600">
                    <p>• Free Shuttle</p>
                    <p>• Recreation Dining</p>
                    <p>• Luxury View</p>
                    <p>• Beautiful Pools</p>
                    <p>• Layers of Green</p>
                </div>
            </div>
            <div class="space-y-6" data-aos="fade-up" data-aos-delay="400">
                <div class="space-y-2 font-body text-gray-600">
                    <p>• Reserve Your Stay</p>
                    <p>• In-Villa Dining</p>
                    <p>• Online Check</p>
                    <p>• Gift Cards</p>
                </div>
                <div class="flex space-x-4">
                    <?php if (isset(variables()["instagram"]["link"])) { ?>
                        <div
                            class="w-10 h-10 bg-gradient-to-br from-gray-200 to-gray-300 rounded-full luxury-shadow flex justify-center items-center">
                            <a href="<?= variables()["instagram"]["link"] ?>" target="_blank">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#000"
                                    class="bi bi-instagram" viewBox="0 0 16 16">
                                    <path
                                        d="M8 0C5.829 0 5.556.01 4.703.048 3.85.088 3.269.222 2.76.42a3.9 3.9 0 0 0-1.417.923A3.9 3.9 0 0 0 .42 2.76C.222 3.268.087 3.85.048 4.7.01 5.555 0 5.827 0 8.001c0 2.172.01 2.444.048 3.297.04.852.174 1.433.372 1.942.205.526.478.972.923 1.417.444.445.89.719 1.416.923.51.198 1.09.333 1.942.372C5.555 15.99 5.827 16 8 16s2.444-.01 3.298-.048c.851-.04 1.434-.174 1.943-.372a3.9 3.9 0 0 0 1.416-.923c.445-.445.718-.891.923-1.417.197-.509.332-1.09.372-1.942C15.99 10.445 16 10.173 16 8s-.01-2.445-.048-3.299c-.04-.851-.175-1.433-.372-1.941a3.9 3.9 0 0 0-.923-1.417A3.9 3.9 0 0 0 13.24.42c-.51-.198-1.092-.333-1.943-.372C10.443.01 10.172 0 7.998 0zm-.717 1.442h.718c2.136 0 2.389.007 3.232.046.78.035 1.204.166 1.486.275.373.145.64.319.92.599s.453.546.598.92c.11.281.24.705.275 1.485.039.843.047 1.096.047 3.231s-.008 2.389-.047 3.232c-.035.78-.166 1.203-.275 1.485a2.5 2.5 0 0 1-.599.919c-.28.28-.546.453-.92.598-.28.11-.704.24-1.485.276-.843.038-1.096.047-3.232.047s-2.39-.009-3.233-.047c-.78-.036-1.203-.166-1.485-.276a2.5 2.5 0 0 1-.92-.598 2.5 2.5 0 0 1-.6-.92c-.109-.281-.24-.705-.275-1.485-.038-.843-.046-1.096-.046-3.233s.008-2.388.046-3.231c.036-.78.166-1.204.276-1.486.145-.373.319-.64.599-.92s.546-.453.92-.598c.282-.11.705-.24 1.485-.276.738-.034 1.024-.044 2.515-.045zm4.988 1.328a.96.96 0 1 0 0 1.92.96.96 0 0 0 0-1.92m-4.27 1.122a4.109 4.109 0 1 0 0 8.217 4.109 4.109 0 0 0 0-8.217m0 1.441a2.667 2.667 0 1 1 0 5.334 2.667 2.667 0 0 1 0-5.334" />
                                </svg></a>
                        </div>
                    <?php } ?>
                    <?php if (isset(variables()["facebook"]["link"])) { ?>
                        <div
                            class="w-10 h-10 bg-gradient-to-br from-gray-200 to-gray-300 rounded-full luxury-shadow flex justify-center items-center">
                            <a href="<?= variables()["facebook"]["link"] ?>" target="_blank">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                    class="bi bi-facebook" viewBox="0 0 16 16">
                                    <path
                                        d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951" />
                                </svg>
                            </a>
                        </div>
                    <?php } ?>
                    <?php if (isset(variables()["tripadvisor"]["link"])) { ?>
                        <div
                            class="w-10 h-10 bg-gradient-to-br from-gray-200 to-gray-300 rounded-full luxury-shadow flex justify-center items-center">
                            <a href="<?= variables()["tripadvisor"]["link"] ?>" target="_blank">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="18" height="18" fill="currentColor">
                                    <path d="M195.8 285.3c0 39.6-32.2 71.8-71.8 71.8s-71.8-32.2-71.8-71.8 32.2-71.8 71.8-71.8 71.8 32.2 71.8 71.8zm-32.4 0c0-21.8-17.7-39.5-39.5-39.5s-39.5 17.7-39.5 39.5 17.7 39.5 39.5 39.5 39.5-17.7 39.5-39.5zm295.5 0c0 39.6-32.2 71.8-71.8 71.8s-71.8-32.2-71.8-71.8 32.2-71.8 71.8-71.8 71.8 32.2 71.8 71.8zm-32.4 0c0-21.8-17.7-39.5-39.5-39.5s-39.5 17.7-39.5 39.5 17.7 39.5 39.5 39.5 39.5-17.7 39.5-39.5zM256 140.6c-56.6 0-104.2 32.6-125.5 79.9-11.8-5.2-24.7-8-38.3-8-51.9 0-94 42.1-94 94s42.1 94 94 94c41.3 0 76.5-26.6 88.6-63.6l48.1 38.7 48.1-38.7c12.1 37 47.3 63.6 88.6 63.6 51.9 0 94-42.1 94-94s-42.1-94-94-94c-13.6 0-26.5 2.9-38.3 8-21.3-47.3-68.9-79.9-125.5-79.9zm0 171.5-35.4-28.5 35.4-28.5 35.4 28.5-35.4 28.5z" />
                                </svg>
                            </a>
                        </div>
                    <?php } ?>
                    <?php if (isset(variables()["youtube"]["link"])) { ?>
                        <div
                            class="w-10 h-10 bg-gradient-to-br from-gray-200 to-gray-300 rounded-full luxury-shadow flex justify-center items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                class="bi bi-youtube" viewBox="0 0 16 16">
                                <path
                                    d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                            </svg>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>-->

<!-- <section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-8">
        <iframe width="100%" height="500" src="https://www.youtube.com/embed/Dwqoi8azIAQ?si=wYIclh5wm2JmWJAD" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
    </div>
</section>
 -->
<!-- Awards Section -->
<!-- <section class="py-16 bg-gray-50 border-t border-gray-100">
    <div class="max-w-7xl mx-auto px-8">
        <div class="text-center font-secondary text-sm text-gray-500 uppercase tracking-widest mb-12"
            data-aos="fade-up">Awards &
            Accreditations</div>
        <div class="flex justify-center items-center space-x-16" data-aos="fade-up" data-aos-delay="200">
            <div class="w-24 h-20 flex items-center justify-center">
                <img src="https://static.tacdn.com/img2/brand_refresh/special/pride_month_Tripadvisor_lockup_horizontal_secondary.svg"
                    alt="ASA Bali Luxury Villas & Spa">
            </div>
            <div class="w-24 h-20 flex items-center justify-center">
                <img src="https://hotelnikkobali-benoabeach.com/wp-content/uploads/2021/01/HNB-CHSE-Certificate.png"
                    alt="ASA Bali Luxury Villas & Spa">
            </div>
        </div>
    </div>
</section> -->

<!-- Accommodation Section -->
<section class="py-32 bg-cover bg-center relative" style="background-image: url('<?= base_url() ?>assets/img/publicarea/1.jpg');">
    <div class="max-w-7xl mx-auto px-8 text-center">
        <h2 class="font-primary text-4xl lg:text-7xl font-light text-white mb-8 text-shadow-luxury"
            data-aos="zoom-in" data-aos-duration="1000">
            Accommodation</h2>
        <div class="accent-line mx-auto mb-8" data-aos="fade-up" data-aos-delay="200"></div>
        <p class="text-white text-xl font-body mb-16 max-w-4xl mx-auto text-shadow-luxury leading-relaxed"
            data-aos="fade-up" data-aos-delay="400">
            Experience our authentic traditional and luxurious five-star facilities whilst enjoying breathtaking
            views and unique experiences on offer.</p>
        <a href="<?= base_url() ?>accommodation.php"
            class="btn-luxury text-gray-900 px-12 py-4 font-secondary text-sm uppercase tracking-widest font-semibold rounded-full"
            data-aos="fade-up" data-aos-delay="600">View Rooms</a>
    </div>
</section>

<!-- Featured Rooms -->
<section class="py-24 bg-[#C78133]">
    <div class="max-w-7xl mx-auto px-8">
        <h2 class="font-primary text-5xl lg:text-6xl font-light text-white text-center mb-20" data-aos="fade-up">
            Featured Rooms
        </h2>
        <div class="flex flex-wrap justify-center gap-12">
                            <div class="group card-luxury bg-[#ffffff] overflow-hidden luxury-shadow rounded-2xl w-full lg:w-1/3 flex flex-col aos-init aos-animate" data-aos="fade-up" data-aos-delay="100">
                <div class="aspect-[4/3] relative">
                    <div class="absolute inset-0 bg-cover bg-center "
                        style="background-image: url('<?= base_url() ?>assets/img/onebedroompoolvilla/1.jpg');">
                    </div>
                </div>
                <div class="p-8">
                    <h3 class="text-[#c68b49] font-primary text-2xl font-light mb-4">One Bedroom Private Pool Villa</h3>
                    <p class="text-[#c68b49] font-body mb-6 leading-relaxed"> Cozy Tropical Bedroom with Private Bathroom. Experience maximum comfort in this beautifully designed bedroom with tropical modern vibes and natural wooden touches</p>
                    <!--   <div class="flex flex-wrap gap-3 font-body text-sm text-gray-400 mb-8">
                        <span>• 300 sqm</span>
                        <span>• 3m x 10m Private Pool</span>
                        <span>• Tropical Lush Garden</span>
                        <span>• King Bed</span>
                    </div> -->
                    <a class="block text-center w-full bg-transparent border-2 gold-border text-[#000000] py-3 font-secondary text-sm uppercase tracking-wider hover:bg-yellow-200 hover:text-gray-900 transition-all duration-300 rounded-full" href="room/one-bedroom-pool-villa">Explore</a>
                </div>
            </div>

            <!-- Room 2 -->
                                        <div class="group card-luxury bg-[#ffffff] overflow-hidden luxury-shadow rounded-2xl w-full lg:w-1/3 flex flex-col aos-init aos-animate" data-aos="fade-up" data-aos-delay="100">
                <div class="aspect-[4/3] relative">
                <div class="aspect-[4/3] relative">
                    <div class="absolute inset-0 bg-cover bg-center "
                        style="background-image: url('<?= base_url() ?>assets/img/twobedroompoolvilla/1.jpg');">
                    </div>
                </div>
                <div class="p-8">
                    <h3 class="text-[#c68b49] group-hover:text-dark font-primary text-2xl font-light mb-4">Two Bedroom Private Pool Villa</h3>
                    <p class="text-[#c68b49] font-body mb-6 leading-relaxed">
                        Cozy Tropical Bedroom with Private Bathroom. Experience maximum comfort in this beautifully designed bedroom with tropical modern vibes and natural wooden
                    </p>
                    <!-- <div class="flex flex-wrap gap-3 font-body text-sm text-gray-400 mb-8">
                        <span>• 300 sqm</span>
                        <span>• 3m x 10m Private Pool</span>
                        <span>• Tropical Lush Garden</span>
                        <span>• King Bed</span>
                    </div> -->
                    <a class="block text-center w-full bg-transparent border-2 gold-border text-[#000000] py-3 font-secondary text-sm uppercase tracking-wider hover:bg-yellow-200 hover:text-gray-900 transition-all duration-300 rounded-full" href="room/two-bedroom-pool-villa">Explore</a>
                </div>
            </div>

          

          


        </div>
    </div>
</section>

<!-- Regional Highlights -->
<!-- <section class="py-24 bg-gradient-to-b from-gray-50 to-white">
    <div class="max-w-7xl mx-auto px-8">
        <h2 class="font-primary text-5xl lg:text-6xl font-light text-center gradient-text mb-20" data-aos="fade-up">
            Discover: Regional Highlights</h2>
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-16">
            <?php
            $discovers = [
                [
                    "title" => "Restaurant & Bar",
                    "description" => "Flavours of culinary art and wine served in the Kubu Bar & Restaurant. A wealth of venues dot the island",
                    "url" => "restaurant",
                    "thumbnail" => "assets/img/restaurant/1.jpg"
                ],
                [
                    "title" => "Toya ASA Spa",
                    "description" => "Waves of energy from the Balinese vibrant culture, rushing ocean currents, abundant marine life.",
                    "url" => "spa",
                    "thumbnail" => "assets/img/spa/1.jpg"
                ],
                [
                    "title" => "Others Service",
                    "description" => "Airport Transfer<br>
                    Price : IDR 450,000.00 /car",
                    "url" => "other",
                    "thumbnail" => "assets/img/publicarea/6.jpg"
                ]
            ]
            ?>
            <?php foreach ($discovers as $discover): ?>
                <div class="text-center" data-aos="fade-up" data-aos-delay="100">
                    <div
                        class="aspect-square bg-gradient-to-br from-green-400 via-green-500 to-green-600 rounded-2xl mb-8 luxury-shadow luxury-border overflow-hidden">
                        <div class="w-full h-full bg-cover bg-center" style="background-image: url('<?= base_url() ?><?= $discover["thumbnail"] ?? "" ?>');">
                        </div>
                    </div>
                    <h3 class="font-primary text-2xl font-light text-gray-900 mb-4">
                        <a href="<?= base_url() ?><?= $discover["url"] ?? "#" ?>"><?= $discover["title"] ?? "" ?></a>
                    </h3>
                    <p class="font-body text-gray-600 leading-relaxed">
                        <?= $discover["description"] ?? "" ?>
                    </p>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section> -->

<?php include_once('components/cta.php'); ?>
<?php include_once('partials/footer.php'); ?>