<?php include_once('partials/header.php'); ?>

<!-- Hero Section -->
<section class="h-[80vh] flex items-center justify-center relative overflow-hidden hero-bg" style="background-image: url('<?= base_url()?>assets/img/publicarea/1.jpg');">
    <div class="text-center text-white z-10">
        <div class="floating-animation">
            <h1 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-shadow-luxury tracking-wide"
                data-aos="zoom-in" data-aos-duration="1500">Package</h1>
            <div class="accent-line mx-auto mb-4" data-aos="fade-up" data-aos-delay="300"></div>
            <!-- <p class="font-secondary text-xl lg:text-2xl font-light text-shadow-luxury tracking-wider italic"
                data-aos="fade-up" data-aos-delay="500">Sanctuaries of Serenity</p> -->
            <p class="font-body text-lg mt-4 text-shadow-luxury tracking-widest opacity-90" data-aos="fade-up"
                data-aos-delay="700">A private and peaceful escape in Seminyak with pool villas and relaxing spa experiences.</p>
        </div>
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black opacity-40"></div>
</section>

<!-- Introduction Section -->
<section class="py-20 bg-gradient-to-b from-white to-gray-50">
    <div class="max-w-5xl mx-auto px-6 text-center">
        <div data-aos="fade-up" class="space-y-8">
            <div class="luxury-divider"></div>
            <h2 class="text-4xl lg:text-5xl font-light text-gray-900 mb-6">
                Asa Bali Luxury 
                <span class="gold-gradient">Villas & Spa</span>
            </h2>
            <p class="signature-text text-gray-700 text-xl leading-relaxed max-w-3xl mx-auto">
                is a peaceful hideaway in the heart of Seminyak. Featuring private pool villas, relaxing spa treatments, and warm Balinese hospitality, it’s the perfect place to unwind and enjoy a tropical escape.
            </p>
        </div>
    </div>
</section>

<section class="py-32 relative">
    <div class="max-w-7xl mx-auto px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-24 items-center">
            <div data-aos="fade-right" data-aos-duration="1000">
                <div class="relative">
                    <div class="absolute -inset-4 bg-gradient-to-r from-yellow-400/20 to-amber-400/20 rounded-3xl blur opacity-30"></div>
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl">
                        <img src="<?= base_url()?>assets/img/superior/1.jpg"
                            alt="ASA Bali Luxury Villas & Spa"
                            class="w-full h-96 object-cover">
                        <div class="absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
                        <div class="absolute bottom-4 left-4 text-white">
                            <span class="bg-yellow-500 px-3 py-1 rounded-full text-sm font-medium">Featured</span>
                        </div>
                    </div>
                </div>
            </div>

            <div data-aos="fade-left" data-aos-duration="1000" class="space-y-8">
                <div class="space-y-6">
                    <div class="luxury-divider"></div>
                    <h3 class="text-4xl lg:text-5xl font-light leading-tight text-gray-900">
                        2 Nights Honeymoon
                        <span class="gold-gradient block">Package</span>
                    </h3>
                 <!--    <div class="flex items-center space-x-4 text-gray-600">
                        <span class="flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                            300m² | 2 Guests
                        </span>
                    </div> -->
                </div>

                <div class="space-y-6">
                    <p class="signature-text text-gray-700 leading-relaxed">
                        Package inclusions :<br>
                        2N/3 Days stay at One Bed Room Private Pool Villa<br>
                        Welcome drink and cold face towel upon arrival<br>
                        Fruit and flower arrangement on arrival<br>
                        Daily American breakfast for couple at Kubu Bar Restaurant or Villa room<br>
                        Petal decoration on the bed and bathtub on arrival
                    </p>

                    <div class="flex md:w-1/2">
                        <a href="<?= variables()["booking"]["link"] ?>" class="luxury-button flex-1 text-center">
                            Book Now
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="py-32 bg-gradient-to-b from-gray-50 to-white">
    <div class="max-w-7xl mx-auto px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-24 items-center">
            <div data-aos="fade-right" data-aos-duration="1000" class="order-2 lg:order-1 space-y-8">
                <div class="space-y-6">
                    <div class="luxury-divider"></div>
                    <h3 class="text-4xl lg:text-5xl font-light leading-tight text-gray-900">
                        3 Nights Honeymoon
                        <span class="gold-gradient block">Package</span>
                    </h3>
                 
                </div>

                <div class="space-y-6">
                    <p class="signature-text text-gray-700 leading-relaxed">
                        Package inclusions :<br>
                        3N/4 Days stay at One Bed Room Private Pool Villa<br>
                        Welcome drink and cold face towel on arrival<br>
                        Daily breakfast for couple at Kubu Bar Restaurant or villa room<br>
                        Petal decoration on the bed and bathtub on arrival<br>
                        Fruit and flower arrangement on arrival<br>
                    </p>

                    
                   

                    <div class="flex md:w-1/2">
                        
                        <a href="<?= variables()["booking"]["link"] ?>" class="luxury-button flex-1 text-center">Book Now</a>
                    </div>
                </div>
            </div>
            <div data-aos="fade-left" data-aos-duration="1000" class="order-1 lg:order-2">
                <div class="relative">
                    <div class="absolute -inset-4 bg-gradient-to-r from-yellow-400/20 to-amber-400/20 rounded-3xl blur opacity-30"></div>
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl">
                        <img src="<?= base_url()?>assets/img/onebedroompoolvilla/1.jpg" alt="ASA Bali Luxury Villas & Spa" class="w-full h-96 object-cover">
                        <div class="absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
                        <div class="absolute bottom-4 left-4 text-white">
                            <span class="bg-yellow-500 px-3 py-1 rounded-full text-sm font-medium">Featured</span>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </div>
</section>

<section class="py-32 bg-gradient-to-b from-gray-50 to-white">
    <div class="max-w-7xl mx-auto px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-24 items-center">
            <div data-aos="fade-right" data-aos-duration="1000" class="lg:order-1">
                <div class="relative">
                    <div class="absolute -inset-4 bg-gradient-to-r from-yellow-400/20 to-amber-400/20 rounded-3xl blur opacity-30"></div>
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl">
                        <img src="<?= base_url()?>assets/img/twobedroompoolvilla/1.jpg" alt="ASA Bali Luxury Villas & Spa" class="w-full h-96 object-cover">
                        <div class="absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
                        <div class="absolute bottom-4 left-4 text-white">
                            <span class="bg-green-500 px-3 py-1 rounded-full text-sm font-medium">Popular</span>
                        </div>
                    </div>
                </div>
            </div>
            <div data-aos="fade-left" data-aos-duration="1000" class="space-y-8 lg:order-2">
                <div class="space-y-6">
                    <div class="luxury-divider"></div>
                    <h3 class="text-4xl lg:text-5xl font-light leading-tight text-gray-900">
                        4 Nights Honeymoon
                        <span class="gold-gradient block">Package</span>
                    </h3>
                   <!--  <div class="flex items-center space-x-4 text-gray-600">
                        <span class="flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            </svg>
                            550m² | 4 Guests
                        </span>
                    </div> -->
                </div>
                <div class="space-y-6">
                    <p class="signature-text text-gray-700 leading-relaxed">
                        Package inclusions :<br>
                        3N/4 Days stay at One Bed Room Private Pool Villa<br>
                        Welcome drink and cold face towel on arrival<br>
                        Daily breakfast for couple at Kubu Bar Restaurant or villa room<br>
                        Petal decoration on the bed and bathtub on arrival<br>
                        Fruit and flower arrangement on arrival<br>
                    </p>
                 
                     <div class="flex md:w-1/2">
                        <a href="<?= variables()["booking"]["link"] ?>" class="luxury-button flex-1 text-center">Book Now</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>





<?php include_once('components/cta.php'); ?>
<?php include_once('partials/footer.php'); ?>