<!-- Footer -->
<footer class="bg-[#C78133] text-white pt-12 pb-6 text-sm font-light" data-aos="fade-up">
    <div class="max-w-7xl mx-auto px-6">

        <!-- Social Media -->
        <div class="flex justify-center space-x-6 text-xl mb-10" data-aos="fade-up" data-aos-delay="100">
            <a href="<?= variables()["facebook"]["link"] ?>" target="_blank"><i class="ri-facebook-fill"></i></a>
            <a href="<?= variables()["instagram"]["link"] ?>" target="_blank"><i class="ri-instagram-line"></i></a>
            <a href="<?= variables()["whatsapp"]["link"] ?>" target="_blank"><i class="ri-whatsapp-line"></i></a>
            <a href="<?= variables()["address"]["link"] ?>" target="_blank"><i class="ri-map-pin-fill"></i></a>
            <a href="<?= variables()["email"]["link"] ?>" target="_blank"><i class="ri-mail-fill"></i></a>
            <a href="<?= variables()["tripadvisor"]["link"] ?>" target="_blank"><i class="ri-chat-quote-line"></i></a>
        </div>

        <!-- Divider -->
        <div class="border-t border-[#ffffff] mb-10"></div>

        <!-- Footer Content -->
        <div class="grid grid-cols-1 md:grid-cols-4 gap-10">
            <!-- OUR BRANDS -->
            <div data-aos="fade-up" data-aos-delay="300">
                <h4 class="uppercase text-white font-semibold tracking-widest mb-4">Links</h4>
                <ul class="space-y-1">
                    <li><a href="index">Home</a></li>
                    <li><a href="accommodation">Accommodation</a></li>
                    
                
                </ul>
            </div>

            <!-- OUR PRODUCTS -->
            <div data-aos="fade-up" data-aos-delay="300">
                <h4 class="uppercase text-white font-semibold tracking-widest mb-4">Our Rooms</h4>
                <ul class="space-y-1">
                    
                    <li><a href="room/one-bedroom-pool-villa">One Bedroom Private Pool Villa</a></li>
                    <li><a href="room/two-bedroom-pool-villa">Two Bedroom Private Pool Villa</a></li>
                    
                </ul>
            </div>


            <!-- CORPORATE / ASSOCIATED -->
            <div data-aos="fade-up" data-aos-delay="400">
                <h4 class="uppercase text-white font-semibold tracking-widest mb-4">Discover</h4>
                <?php
                $discovers = [
                    [
                        "title" => "Discover our best services",
                        "description" => "Experience warm, personalized service delivered with humility and a human touch.",
                        "thumbnail" => "assets/img/publicarea/1.jpg"
                    ],
                    [
                        "title" => "Comfort Pool Villa",
                        "description" => "Embrace spiritual renewal through sacred water blessings, honoring Balinese heritage in a serene temple setting.",
                        "thumbnail" => "assets/img/onebedroompoolvilla/2.jpg"
                    ],
                    [
                        "title" => "A Place of Comfort and Purpose",
                        "description" => "Discover a peaceful retreat designed for comfort and clarity a space to read, reflect, and realign with what truly matters.",
                        "thumbnail" => "assets/img/twobedroompoolvilla/1.jpg"
                    ]
                ]
                ?>
                <ul class="space-y-1">
                    <?php foreach ($discovers ?? [] as $discover): ?>
                        <li><?= $discover["title"] ?? "" ?></li>
                    <?php endforeach ?>
                </ul>
            </div>

         

             <!-- CONTACT US -->
            <div data-aos="fade-up" data-aos-delay="500">
                <h4 class="uppercase text-white font-semibold tracking-widest mb-4">Contact Us</h4>
                <ul class="space-y-1">
                    <li><?= variables()["address"]["text"] ?></li>
                    <li><a href="<?= variables()["email"]["link"] ?>" target="_blank"><?= variables()["email"]["text"] ?></a></li>
                    <li><?= variables()["whatsapp"]["text"] ?></li>
                </ul>
            </div>
        </div>

        <!-- Bottom Bar -->
        <div
            class="border-t border-[#ffffff] mt-10 pt-6 flex flex-col md:flex-row justify-between items-center text-xs text-[#ffffff] space-y-4 md:space-y-0">
            <div>
                <p>Copyright © <?= date('Y') ?> - <a href="http://booknpay.net/">BOOKNPAY</a>. All rights reserved</p>
            </div>
            <div class="flex items-center space-x-6 mt-4 md:mt-0">
                <?= variables()["title"] ?? "" ?>
            </div>
        </div>
    </div>
</footer>

<!-- AOS JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js"></script>

<script>
    // Initialize AOS
    AOS.init({
        duration: 1000,
        easing: 'ease-in-out',
        once: true,
        offset: 100
    });
</script>

<script>
    const mobileMenuButton = document.getElementById('mobile-menu-button');
    const mobileMenu = document.getElementById('mobile-menu');
    const hamburger = document.querySelector('.hamburger');
    const closeMenuButton = document.getElementById('close-menu-button');

    // Open mobile menu
    mobileMenuButton.addEventListener('click', function() {
        mobileMenu.classList.toggle('active');
        hamburger.classList.toggle('active');
    });

    // Close mobile menu with close button
    closeMenuButton.addEventListener('click', function() {
        mobileMenu.classList.remove('active');
        hamburger.classList.remove('active');
    });

    // Close mobile menu when clicking on menu items
    const menuItems = document.querySelectorAll('#mobile-menu a');
    menuItems.forEach(item => {
        item.addEventListener('click', function() {
            mobileMenu.classList.remove('active');
            hamburger.classList.remove('active');
        });
    });

    // Close mobile menu when clicking outside
    document.addEventListener('click', function(event) {
        if (!mobileMenu.contains(event.target) && !mobileMenuButton.contains(event.target)) {
            mobileMenu.classList.remove('active');
            hamburger.classList.remove('active');
        }
    });
</script>
</body>

</html>