<?php include_once('partials/header.php'); ?>
<?php ?>

<!-- Hero Section -->
<section class="h-[80vh] flex items-center justify-center relative overflow-hidden hero-bg" style="background-image: url('assets/img/publicarea/6.jpg');">
    <div class="text-center text-white z-10">
        <div class="floating-animation">
            <h1 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-shadow-luxury tracking-wide"
                data-aos="zoom-in" data-aos-duration="1500">Contact</h1>
            <div class="accent-line mx-auto mb-4" data-aos="fade-up" data-aos-delay="300"></div>
            <p class="font-secondary text-xl lg:text-2xl font-light text-shadow-luxury tracking-wider italic"
                data-aos="fade-up" data-aos-delay="500">Sanctuaries of Serenity</p>
            <p class="font-body text-lg mt-4 text-shadow-luxury tracking-widest opacity-90" data-aos="fade-up"
                data-aos-delay="700">Where every room tells a story of Balinese elegance and timeless comfort</p>
        </div>
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black opacity-40"></div>
</section>

<!-- Introduction Section -->
    <section id="contact_form" class="py-20 bg-white">
        <div class="max-w-5xl mx-auto px-6">
            <h2 class="text-3xl font-light mb-8 text-center">Get in Touch</h2>
            <?php if (isset($_SESSION['success'])) : ?>
                <div class="alert alert-success alert-dismissible fade show bg-green-300 px-3 py-4 rounded mb-5 relative"
                    role="alert">
                    <?= $_SESSION['success']; ?>
                    <button type="button" class="btn-close absolute right-[20px]" data-bs-dismiss="alert" aria-label="Close"><i
                            class="fa-solid fa-xmark"></i></button>
                </div>
                <?php $_SESSION['success'] = null; ?>
            <?php endif; ?>
            <?php if (isset($_SESSION['error'])) : ?>
                <div class="alert alert-error alert-dismissible fade show bg-red-300 px-3 py-4 rounded mb-5 relative"
                    role="alert">
                    <?= $_SESSION['error']; ?>
                    <button type="button" class="btn-close absolute right-[20px]" data-bs-dismiss="alert" aria-label="Close"><i
                            class="fa-solid fa-xmark"></i></button>
                </div>
                <?php $_SESSION['error'] = null; ?>
            <?php endif; ?>
            <form action="<?= base_url()?>contactProccess.php" method="POST" class="grid grid-cols-1 gap-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="first-name" class="block text-sm font-medium mb-2">First Name <span
                                class="text-red-500">*</span></label>
                        <input type="text" id="first-name" name="first-name" value="" required
                            class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-gray-400">
                    </div>
                    <div>
                        <label for="last-name" class="block text-sm font-medium mb-2">Last Name</label>
                        <input type="text" id="last-name" name="last-name" value=""
                            class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-gray-400">
                    </div>
                </div>

                <div>
                    <label for="email" class="block text-sm font-medium mb-2">Email <span
                            class="text-red-500">*</span></label>
                    <input type="email" id="email" name="email" value="" required
                        class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-gray-400">
                </div>

                <div>
                    <label for="message" class="block text-sm font-medium mb-2">Message <span
                            class="text-red-500">*</span></label>
                    <textarea id="message" name="message" rows="5" required
                        class="w-full border border-gray-300 rounded-lg px-4 py-3 focus:outline-none focus:ring-2 focus:ring-gray-400"></textarea>
                </div>

                <div>
                    <div class="g-recaptcha" data-sitekey="<?= variables()['recaptcha']['site']?>"></div>
                </div>

                <div class="text-center">
                    <button type="submit"
                        class="px-8 py-3 bg-black text-white font-medium rounded-lg shadow hover:bg-gray-800 transition">
                        Send Message
                    </button>
                </div>
            </form>

        </div>
    </section>

    <section id="contact_map" class="h-[450px]">
        <iframe
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3942.65600978435!2d115.1911862738242!3d-8.81835019021641!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2dd25dd3e0b59da5%3A0xfeeeceaa668be283!2sVilla%20Mandala%20Hill!5e0!3m2!1sid!2sid!4v1756198035569!5m2!1sid!2sid"
            width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"
            referrerpolicy="no-referrer-when-downgrade"></iframe>
    </section>

<?php include_once('components/cta.php'); ?>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<?php include_once('partials/footer.php'); ?>