<?php include_once(__DIR__ . '/../partials/header.php'); ?>

<section id="discover_detail_hero" class="hero-bg h-[70vh] flex items-center justify-center relative overflow-hidden" style="background-image: url('<?= base_url()?>assets/img/onebedroomkembangkertas/12.jpg');">
    <div class="text-center text-white z-10">
        <div class="floating-animation mt-12">
            <h1 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-shadow-luxury tracking-wide"
                data-aos="zoom-in" data-aos-duration="1500">A Place of Comfort and Purpose</h1>
            <div class="accent-line mx-auto mb-4" data-aos="fade-up" data-aos-delay="300"></div>
            <p class="font-secondary text-xl lg:text-2xl font-light text-shadow-luxury tracking-wider italic"
                data-aos="fade-up" data-aos-delay="500">Discover a peaceful retreat designed for comfort and clarity a space to read, reflect, and realign with what truly matters.</p>
            <p class="font-body text-lg mt-4 text-shadow-luxury tracking-widest opacity-90" data-aos="fade-up"
                data-aos-delay="700"><?= variables()["title"] ?></p>
        </div>
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black opacity-20"></div>
</section>

<section id="discover_detail_content" class="py-24 bg-white">
    <div class="max-w-7xl mx-auto px-8">
        <h2 class="text-4xl font-light mb-6">A Place of Comfort and Purpose</h2>

        <p class="text-lg mb-4">
            Sometimes, the most meaningful journeys are the ones we take inward. At <strong>The Maya Seminyak</strong>, we’ve created a tranquil retreat designed not only for physical rest, but for emotional clarity and soulful reflection — a space where comfort and purpose gently meet.
        </p>

        <p class="mb-4">
            This is more than a room — it’s a sanctuary. Whether you wish to lose yourself in a good book, sit quietly with your thoughts, or simply breathe in stillness, this space invites you to slow down and rediscover what truly matters. Free from distraction, wrapped in gentle design and natural light, it encourages you to reconnect — with yourself, with your story, and with your next step.
        </p>

        <h3 class="text-2xl font-semibold mt-10 mb-4">Designed for Stillness and Depth</h3>
        <p class="mb-4">
            Every element of the space is intentional: soft textures, warm woods, quiet corners, and views that stretch beyond the physical — toward peace. Whether you spend your time journaling, meditating, or simply being present, the ambiance supports calm awareness and quiet renewal.
        </p>

        <p class="mb-4">
            Natural light pours in by day, creating a serene rhythm that moves with you. At night, soft lamps and peaceful silence hold space for rest and release. Here, every breath becomes more meaningful. Every pause becomes sacred.
        </p>

        <h3 class="text-2xl font-semibold mt-10 mb-4">For Readers, Dreamers, and Seekers</h3>
        <p class="mb-4">
            Whether you're a writer, a dreamer, or someone simply needing space to think, this retreat welcomes you. It’s the kind of place where you can spend hours reading without noticing time, or wake up with a new clarity that feels like coming home to yourself.
        </p>

        <p class="mb-4">
            Let this be the chapter where you slow down. Where you remember your path. Where comfort gives you the quiet strength to realign with your purpose — gently, naturally, and without pressure.
        </p>

        <div class="mt-10 text-center">
            <p class="italic text-gray-600">Find your quiet. Feel your truth. Welcome home.</p>
        </div>

    </div>
</section>


<?php include_once(__DIR__ . '/../components/cta.php'); ?>
<?php include_once(__DIR__ . '/../partials/footer.php'); ?>