<?php include_once(__DIR__ . '/../partials/header.php'); ?>

<section id="discover_detail_hero" class="hero-bg h-[70vh] flex items-center justify-center relative overflow-hidden" style="background-image: url('<?= base_url()?>assets/img/onebedroomkembangkertas/10.jpg');">
    <div class="text-center text-white z-10">
        <div class="floating-animation mt-12">
            <h1 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-shadow-luxury tracking-wide"
                data-aos="zoom-in" data-aos-duration="1500">Comfort Pool Villa</h1>
            <div class="accent-line mx-auto mb-4" data-aos="fade-up" data-aos-delay="300"></div>
            <p class="font-secondary text-xl lg:text-2xl font-light text-shadow-luxury tracking-wider italic"
                data-aos="fade-up" data-aos-delay="500">Embrace spiritual renewal through sacred water blessings, honoring Balinese heritage in a serene temple setting.</p>
            <p class="font-body text-lg mt-4 text-shadow-luxury tracking-widest opacity-90" data-aos="fade-up"
                data-aos-delay="700"><?= variables()["title"] ?></p>
        </div>
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black opacity-20"></div>
</section>

<section id="discover_detail_content" class="py-24 bg-white">
    <div class="max-w-7xl mx-auto px-8">
        <h2 class="text-4xl font-light mb-6">Comfort Pool Villa</h2>

  <p class="text-lg mb-4">
    Tucked away in a lush corner of The Maya Seminyak, the <strong>Comfort Pool Villa</strong> is a private sanctuary designed for those seeking rest, intimacy, and soulful renewal. With its own plunge pool, elegant interiors, and outdoor living space, this villa blends contemporary luxury with authentic Balinese charm.
  </p>

  <p class="mb-4">
    Every element — from the hand-carved wooden accents to the warm ambient lighting — is curated to create a soothing atmosphere that helps you unwind from the moment you step in. Whether you're enjoying a morning swim under the soft tropical sun or relaxing in the shade of your private gazebo, the villa offers a haven of peace, far removed from the rush of everyday life.
  </p>

  <h3 class="text-2xl font-semibold mt-8 mb-4">A Journey of Spiritual Renewal</h3>

  <p class="mb-4">
    What makes the Comfort Pool Villa truly special is the opportunity to engage in a deeply moving <strong>Balinese water blessing ceremony</strong>. Rooted in ancient tradition, this ritual takes place at a sacred temple near the resort — a tranquil setting surrounded by flowing water, statues of deities, and the scent of incense in the air.
  </p>

  <p class="mb-4">
    Guided by a local priest, you will be invited to cleanse your spirit through holy water, prayers, and symbolic offerings. It is more than just a cultural experience — it is a moment of reflection, healing, and personal clarity. Guests often describe it as the emotional highlight of their visit, connecting them deeply to Bali’s spiritual essence.
  </p>

  <h3 class="text-2xl font-semibold mt-8 mb-4">Designed for Comfort and Meaning</h3>

  <p class="mb-4">
    The villa is equipped with all the amenities you'd expect: a spacious king-sized bed with premium linens, a rainfall shower and deep soaking tub, complimentary Wi-Fi, smart TV, minibar, and curated in-room wellness touches. In-villa dining is also available, allowing you to savor gourmet dishes in the privacy of your serene retreat.
  </p>

  <p class="mb-4">
    Whether you’re traveling as a couple, seeking a mindful solo retreat, or celebrating a special occasion, the Comfort Pool Villa is a place to slow down and reconnect — with yourself, your partner, and the spiritual beauty of Bali.
  </p>

  <h3 class="text-2xl font-semibold mt-8 mb-4">Let the Island Embrace You</h3>

  <p class="mb-4">
    At The Maya Seminyak, our mission is to offer more than just a luxurious stay. We aim to provide a space where every guest can feel grounded, inspired, and genuinely cared for. Your time in the Comfort Pool Villa isn’t just a getaway — it’s a personal journey shaped by peace, purpose, and presence.
  </p>

  <p class="mt-6 text-base italic text-gray-600">
    Come home to the sacred. Come home to comfort.
  </p>

    </div>
</section>


<?php include_once(__DIR__ . '/../components/cta.php'); ?>
<?php include_once(__DIR__ . '/../partials/footer.php'); ?>