<?php include_once(__DIR__ . '/../partials/header.php'); ?>

<section id="discover_detail_hero" class="hero-bg h-[70vh] flex items-center justify-center relative overflow-hidden" style="background-image: url('/assets/img/publicarea/9.jpg');">
    <div class="text-center text-white z-10">
        <div class="floating-animation mt-12">
            <h1 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-shadow-luxury tracking-wide"
                data-aos="zoom-in" data-aos-duration="1500">Discover Our Best Services</h1>
            <div class="accent-line mx-auto mb-4" data-aos="fade-up" data-aos-delay="300"></div>
            <p class="font-secondary text-xl lg:text-2xl font-light text-shadow-luxury tracking-wider italic"
                data-aos="fade-up" data-aos-delay="500">Experience warm, personalized service delivered with humility and a human touch.</p>
            <p class="font-body text-lg mt-4 text-shadow-luxury tracking-widest opacity-90" data-aos="fade-up"
                data-aos-delay="700"><?= variables()["title"] ?></p>
        </div>
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black opacity-20"></div>
</section>

<section id="discover_detail_content" class="py-24 bg-white">
    <div class="max-w-7xl mx-auto px-8">
        <h2 class="text-4xl font-light mb-6">Discover Our Best Services</h2>
        <p class="text-lg mb-4">
            <strong>The Maya Seminyak</strong> offers more than a stay — we offer an experience shaped by warmth, grace, and genuine care. Nestled in Bali’s most vibrant coastal town, our resort is a sanctuary where modern luxury meets heartfelt Balinese hospitality.
        </p>

        <p class="mb-4">
            From the moment you arrive, you are greeted with sincere smiles and attentive service. Whether you're seeking serenity, adventure, or connection, we are here to make you feel seen, welcomed, and valued — always with humility and a human touch.
        </p>

        <h3 class="text-2xl font-semibold mt-8 mb-4">What Makes Our Services Special?</h3>

        <ul class="space-y-4 list-disc list-inside">
            <li>
                <strong>Personalized Hospitality:</strong> We tailor your stay around your unique preferences — from room ambiance to curated local experiences.
            </li>
            <li>
                <strong>Seamless Comfort:</strong> Enjoy our beautifully designed spaces with attentive room service, daily housekeeping, and everything you need for peace of mind.
            </li>
            <li>
                <strong>Authentic Balinese Experiences:</strong> Reconnect through sacred rituals, water blessings, and wellness traditions passed down for generations.
            </li>
            <li>
                <strong>Thoughtful Dining Moments:</strong> Indulge in a culinary journey filled with fresh local ingredients, crafted with passion by our chefs.
            </li>
            <li>
                <strong>Heartfelt Staff:</strong> Our team embodies the essence of Bali — warm, respectful, and always ready to serve from the heart.
            </li>
        </ul>

        <h3 class="text-2xl font-semibold mt-10 mb-4">Come Home to Maya</h3>
        <p class="mb-4">
            Whether you're here for relaxation, romance, or self-discovery, The Maya Seminyak welcomes you like family. Let your time with us be more than a vacation — let it be a memory that lingers long after you leave.
        </p>

    </div>
</section>

<?php include_once(__DIR__ . '/../components/cta.php'); ?>
<?php include_once(__DIR__ . '/../partials/footer.php'); ?>