<?php include_once(__DIR__ . '/../partials/header.php'); ?>

<!-- Hero Section -->
<section class="h-[80vh] flex items-center justify-center relative overflow-hidden hero-bg" style="background-image: url('/assets/img/publicarea/8.jpg');">
    <div class="text-center text-white z-10">
        <div class="floating-animation">
            <h1 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-shadow-luxury tracking-wide"
                data-aos="zoom-in" data-aos-duration="1500">Discover Moments</h1>
            <div class="accent-line mx-auto mb-4" data-aos="fade-up" data-aos-delay="300"></div>
            <p class="font-secondary text-xl lg:text-2xl font-light text-shadow-luxury tracking-wider italic"
                data-aos="fade-up" data-aos-delay="500">Curated experiences for discerning souls</p>
            <p class="font-body text-lg mt-4 text-shadow-luxury tracking-widest opacity-90" data-aos="fade-up"
                data-aos-delay="700">Discover extraordinary moments with our handpicked collection of luxury experiences and seasonal celebrations</p>
        </div>
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black opacity-40"></div>
</section>

<!-- Seasonal Offers -->
<section class="py-32 seasonal-bg relative">
    <div class="max-w-7xl mx-auto px-6 relative z-10">
        <div class="text-center mb-20" data-aos="fade-up">
            <div class="luxury-divider"></div>
            <h2 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-gray-900">
               Discover Moments
            </h2>
            <p class="font-secondary text-xl text-gray-600 max-w-2xl mx-auto">
                Special moments throughout the year, crafted to honor tradition and create lasting memories
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <?php 
               $discovers = [
                [
                    "title" => "Restaurant & Bar",
                    "description" => "Flavours of culinary art and wine served in the Kubu Bar & Restaurant. A wealth of venues dot the island",  
                    "url" => "discover/restaurant",
                    "thumbnail" => "assets/img/restaurant/1.jpg"
                ],
                [
                    "title" => "Toya ASA Spa",
                    "description" => "Waves of energy from the Balinese vibrant culture, rushing ocean currents, abundant marine life.",    
                    "url" => "discover/spa",
                    "thumbnail" => "assets/img/spa/1.jpg"
                ],
                [
                    "title" => "Others Service",
                    "description" => "Airport Transfer<br>
                    Price : IDR 450,000.00 /car",
                    "url" => "discover/others-service",    
                    "thumbnail" => "assets/img/publicarea/6.jpg"
                ]
               ]
            ?>
            <?php foreach($discovers as $discover): ?>
            <div data-aos="fade-up" data-aos-delay="200" class="luxury-card rounded-3xl overflow-hidden">
                <div class="relative h-64 overflow-hidden">
                    <img src="<?= base_url()?><?= $discover['thumbnail'] ?? "#"?>"
                        alt="Summer Solstice"
                        class="w-full h-full object-cover offer-image">
                </div>
                <div class="p-6">
                    <h3 class="font-primary text-xl font-semibold text-gray-900 mb-4"><?= $discover["title"] ?? ""?></h3>
                    <p class="text-gray-700 mb-4 text-sm">
                        <?= $discover["description"] ?? ""?>
                    </p>
                    <div class="flex items-center justify-end">

                        <a href="<?= base_url()?><?= $discover["url"] ?? "#"?>" class="text-yellow-600 font-semibold hover:text-yellow-700 transition-colors">
                            Learn More →
                        </a>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<?php include_once(__DIR__ . '/../components/cta.php'); ?>
<?php include_once(__DIR__ . '/../partials/footer.php'); ?>