<?php 
    $header_data = [
        "metadata" => [
            "title" => "Galleries",
            "description" => "Explore captivating views and intimate details from our serene villa collection.",
            "keyword" => "Our galleries, capture moment"
        ]
    ]
?>

<?php include_once(__DIR__ . '/partials/header.php'); ?>

<section id="room_detail_hero" class="hero-bg h-[70vh] flex items-center justify-center relative overflow-hidden lazy"  style="background-image: url('<?= base_url()?>assets/img/publicarea/6.jpg');">
    <div class="text-center text-white z-10">
        <div class="floating-animation mt-12">
            <h1 class="font-primary text-5xl lg:text-6xl font-light mb-6 text-shadow-luxury tracking-wide"
                data-aos="zoom-in" data-aos-duration="1500">Galleries</h1>
            <div class="accent-line mx-auto mb-4" data-aos="fade-up" data-aos-delay="300"></div>
            <p class="font-secondary text-xl lg:text-2xl font-light text-shadow-luxury tracking-wider italic"
                data-aos="fade-up" data-aos-delay="500">Explore captivating views and intimate details from our serene villa collection.</p>
            <p class="font-body text-lg mt-4 text-shadow-luxury tracking-widest opacity-90" data-aos="fade-up"
                data-aos-delay="700"><?= variables()["title"]?></p>
        </div>
    </div>
    <div class="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black opacity-20"></div>
</section>

<?php render(__DIR__ . '/components/galleries.php', [
    "section_data" => [
        "id" => "list_gallery",
        "class" => "bg-gradient-to-b from-gray-50 to-white",
        "title" => "Public Area Gallery",
        "galleries" => [
            [
                "link" => "assets/img/publicarea/1.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/publicarea/2.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/publicarea/3.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/publicarea/4.jpg",
                "text" => ""
            ],
            
           
        ]
    ]
]) ?>

<?php render(__DIR__ . '/components/galleries.php', [
    "section_data" => [
        "id" => "list_gallery",
        "class" => "bg-gradient-to-b from-gray-50 to-white",
        "title" => "Room Gallery",
        "galleries" => [
            [
                "link" => "assets/img/onebedroompoolvilla/1.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/onebedroompoolvilla/2.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/onebedroompoolvilla/3.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/onebedroompoolvilla/4.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/twobedroompoolvilla/1.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/twobedroompoolvilla/2.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/twobedroompoolvilla/3.jpg",
                "text" => ""
            ],
            [
                "link" => "assets/img/twobedroompoolvilla/4.jpg",
                "text" => ""
            ],
            
            
        ]
    ]
]) ?>



<?php include_once(__DIR__ . '/components/cta.php'); ?>
<?php include_once(__DIR__ . '/partials/footer.php'); ?>